// Autor: Goran Zuzic

#include <cassert>
#include <cstring>

#include <algorithm>
#include <iostream>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < int(b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

const int MAXN = 123;
int n, k;
char grid[MAXN][MAXN];

int main(void) {
  scanf("%d %d", &n, &k);
  REP(i, n) scanf("%s", grid[i]);

  int ans = 1e9;
  for (int sx = k-1; sx+k <= n; ++sx) {
    for (int sy = k-1; sy+k <= n; ++sy) {
      int frek[MAXN][26];
      memset(frek, 0, sizeof frek);

      FOR(i, sx-k+1, sx+k) FOR(j, sy-k+1, sy+k) {
        int d = max(abs(i-sx), abs(j-sy));
        assert(d < k);
        ++frek[d][grid[i][j] - 'A'];
      }

      int sum = 0;
      REP(d, k) {
        int uk = 0, maks = 0;
        REP(i, 26) { uk += frek[d][i]; maks = max(maks, frek[d][i]); }
        assert(uk == 8*d + (d==0));
        sum += uk - maks;
      }
      ans = min(ans, sum);
    }
  }

  printf("%d\n", ans);
  return 0;
}   
